#include <bits/stdc++.h>
#define MAX_N 1005

using namespace std;

int d[MAX_N];
bool visited[MAX_N];
vector<int> graph[MAX_N];

void dfs(int curr_node, int dist_traveled) {
    if(visited[curr_node]) {
        return ;
    }
    visited[curr_node] = true;
    d[curr_node] = dist_traveled;
    for(auto iter_node : graph[curr_node]) {
        dfs(iter_node, dist_traveled + 1);
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int t;
    cin >> t;
    while(t--) {
        int n, k;
        cin >> n >> k;
        for(int i = 0; i < n; i++) {
            graph[i].clear();
        }
        for(int i = 0; i < n - 1; i++) {
            int a, b;
            cin >> a >> b;
            a--;
            b--;
            graph[a].push_back(b);
            graph[b].push_back(a);
        }
        fill(visited, visited + n, false);
        fill(d, d + n, 0);
        dfs(0, 0);
        int farthest_node = 0;
        int its_distance = 0;
        for(int i = 1; i < n; i++) {
            if(d[i] > its_distance) {
                farthest_node = i;
                its_distance = d[i];
            }
        }
        fill(visited, visited + n, false);
        fill(d, d + n, 0);
        dfs(farthest_node, 0);
        int ans = 0;
        for(int i = 0; i < n; i++) {
            ans = max(ans, d[i]);
        }
        cout << ans << "\n";
    }
    return 0;
}